package com.flashdynamix.motion.easing {

	/**
	 * Ease params designed specifically for use with the Back ease equation.
	 * 
	 * @see com.flashdynamix.motion.TweensyTimeline#easeParams
	 * @see fl.motion.easing.Back
	 */
	public dynamic class BackEaseParams extends Array {
		
		/**
		 * @param overshoot Sets the overshoot for the Back tween. Where the higher the value, 
	 	 * the greater the overshoot.
		 */
		public function BackEaseParams(overshoot : Number = 2) {
			super([]);
			this.overshoot = overshoot;
		}

		public function set overshoot(amount : Number) : void {
			this[0] = amount;
		}
		
		/**
		 * Sets and returns the overshoot for the Back tween. Where the higher the value, 
	 	 * the greater the overshoot.
		 */
		public function get overshoot() : Number {
			return this[0];
		}
	}
}
